%define module_version 0.03
%define module_name DateTimeX-Period
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Provides safe methods to get start and end of period
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/V/VY/VYTAS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
DateTimeX::Period is a subclass of DateTime & provides easy yet safe methods
to work in period context such as a day for all timezones.

It is recommended practise to work in UTC and switch to specific timezones only
when needed. IF YOU CAN DO SO, THEN THIS MODULE IS NOT FOR YOU!!!

Yet sometimes this is not possible and this module can help you. It works
around such problems like:

1. Assume you want to get start of the month, it's convenient to use
truncate() available in DateTime, however this would throw an error:

 use DateTime;
 my $dt = DateTime->new(
 _year      => 2011,
 _month     => 4,
 _day       => 2,
 _time_zone => 'Asia/Amman'
 );
 $dt->truncate(to => 'month'); # Runtime error

Q: You might have guessed, what did I do wrong?
 A: Well time between 00:00 - 00:59 01/04/2011 in 'Asia/Amman' did not exist.
 There are cases when you can't truncate to weeks, days or even hours!
 ( see unit tests ).

2. Assume your client that lives in 'America/Goose_Bay' is running your app and
today is 13/03/2010 00:05, and your app for whatever reason adds a day:

 use DateTime;
 my $dt = DateTime->new(
 _year      =>2010,
 _month     => 3,
 _day       => 13,
 _minute    => 5,
 _time_zone => 'America/Goose_Bay',
 );
 $dt->add(days => 1); # Runtime error!

Q: What's wrong now?
 A: 14/03/2010 00:05 in 'America/Goose_Bay' did not exist!

3. Assume you are running critical application that needs to get epoch!
Conveniently DateTime has epoch() and for whatever reasons you need to perform
some operations, such as these:
 use DateTime;
 my $dt = DateTime->new(
 _year=> 2013,
 _month => 10,
 _day => 26,
 _hour => 23,
 _minute => 59,
_second => 59,
 _time_zone => 'Atlantic/Azores',
 );
 $dt->add( seconds => 1 );    # 2013-10-27T00:00:00  same
 print $dt->epoch();          # 1382832000           diff!!!
 $dt->truncate(to => 'hour'); # 2013-10-27T00:00:00  same
 print $dt->epoch();          # 1382835600           diff!!!

Q: Why epoch() returns different epoch time when local time doesn't change?
 A: It so happens that 00:00 occurred twice! DateTime documentation classify this
 as ambiguous and always returns later date! Whereas get_start('hour') from
 DateTimeX::Period ( i.e. this module ), would have returned correct epoch:
 use DateTimeX::Period;
 my $dt = DateTime::Period->new(
 _year=> 2013,
 _month => 10,
 _day => 26,
 _hour => 23,
 _minute => 59,
_second => 59,
 _time_zone => 'Atlantic/Azores',
 );
 $dt->add( seconds => 1 );    # 2013-10-27T00:00:00  same
 print $dt->epoch();          # 1382832000           same
 $dt->get_start('hour');      # 2013-10-27T00:00:00  same
 print $dt->epoch();          # 1382832000           same


All in all, this is convenient and safe module to play with when you can't use
UTC time. It is great solution for such case as following:
$user cannot use more than $threshold of something within a day in his local
time or within your operating timezone. Hence query database using its APIs to
get $user's $threshold so far and react upon:
 pretended_api_call_GET_DATA(
 _from => $dt->get_start('day')->epoch(),
 _to   => $dt->get_end('day')->epoch(),
 );
%prep
%setup -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes
%perl_vendor_privlib/D*

%changelog
