# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Lib.pm) perl(Test/More.pm) perl(constant.pm) perl(feature.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Debug-Helper-Flag
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Define and import boolean constant DEBUG_FLAG helping to optimize code.
Group: Development/Perl
License: perl_5
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AA/AAHAZRED/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module lets you set a constant `Debug::Helper::Flag::DEBUG_FLAG' which is
imported on demand. Intended to be used to optimze code like this:

  use Debug::Helper::Flag 'DEBUG_FLAG';

  # ...
  sub Foo {
    if (DEBUG_FLAG) { do_argument_check }
    # ...
  }

If `DEBUG_FLAG' is *true*, then `do_argument_check' is executed but if
it is *false* then the perl compiler will completely optimize away the
statement, including the surrounding `if(...)' construction. The constant
must be set to *true* or *false* before you can import it. The
constant should be specified in the main script or on the command line.

  use Debug::Helper::Flag DEBUG_FLAG => 0;

or

  use Debug::Helper::Flag DEBUG_FLAG => 1;


or on the command line

  perl -MDebug::Helper::Flag=DEBUG_FLAG,1 ...

If you need to specify and use the constant in the same script, then you
can do:

  use Debug::Helper::Flag 'DEBUG_FLAG', DEBUG_FLAG => 1;

Note: using this

  use Debug::Helper::Flag DEBUG_FLAG => EXPRESSION;

multiple times is not a problem provided that *`EXPRESSION'* always
evaluates to the same boolean value. Otherwise the script terminates with
error message `Attempt to redefine DEBUG_FLAG with different value'.

Note: only load this module directly via `use' or in a `BEGIN' block and
never try to load it at runtime, otherwise the optimization will not work!

If you try to import `DEBUG_FLAG' while it is not yet defined, the warning
"Attempt to export while constant is not yet defined" is printed. If you want
a fatal error instead, set the environment variable
`PERL_DEBUG_HELPER_FLAG_STRICT' (or `$Debug::Helper::Flag::strict') to a
*true* value. This is a warning by default to avoid problems when using
the Perl::LanguageServer manpage with e.g. the corresponding vs code plugin.



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
