%define module_name Devel-Confess
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IPC/Open3.pm) perl(Safe.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(UNIVERSAL/can.pm) perl(UNIVERSAL/isa.pm) perl(threads.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.009004
Release: alt1
Summary: Include stack traces on all warnings and errors
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HAARG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is meant as a debugging aid. It can be used to make a script
complain loudly with stack backtraces when warn()ing or die()ing.  Unlike other
similar modules (e.g. the Carp::Always manpage), it includes stack traces even when
exception objects are thrown.

The stack traces are generated using the Carp manpage, and will look work for all types
of errors.  the Carp manpage's `carp' and `confess' functions will also be made to
include stack traces.

  # it works for explicit die's and warn's
  $ perl -MDevel::Confess -e 'sub f { die "arghh" }; sub g { f }; g'
  arghh at -e line 1.
          main::f() called at -e line 1
          main::g() called at -e line 1

  # it works for interpreter-thrown failures
  $ perl -MDevel::Confess -w -e 'sub f { $a = shift; @a = @$a };' \
                                        -e 'sub g { f(undef) }; g'
  Use of uninitialized value $a in array dereference at -e line 1.
          main::f(undef) called at -e line 2
          main::g() called at -e line 2

Internally, this is implemented with `$SIG{__WARN__}' and `$SIG{__DIE__}'
hooks.

Stack traces are also included if raw non-object references are thrown.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
