%define module_name Devel-Declare-Lexer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Devel/Declare.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.014
Release: alt2
Summary: Easier than Devel::Declare
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IA/IANKENT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Devel::Declare::Lexer manpage makes it easier to parse code using the Devel::Declare manpage
by generating a token stream from the statement and providing a callback for
you to manipulate it before its parsed by Perl.

The example in the synopsis creates a keyword named 'keyword', which accepts
a string and prints it.

Although this simple example could be done using print, say or any other simple
subroutine, the Devel::Declare::Lexer manpage supports much more flexible syntax.

For example, it could be used to auto-expand subroutine declarations, e.g.
    method MethodName ( $a, @b ) {
        ... 
    }
into
    sub MethodName ($@) {
        my ($self, $a, @b) = @_;
        ...
    }

Unlike the Devel::Declare manpage, there's no need to worry about parsing text and
taking care of multiline strings or code blocks - it's all done for you.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README example
%perl_vendor_privlib/D*

%changelog
