Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Exception/LessClever.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Devel-Declare-Parser
Version:        0.021
Release:        alt1_3
Summary:        Higher level interface to Devel-Declare
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Devel-Declare-Parser
Source0:        https://cpan.metacpan.org/authors/id/E/EX/EXODIST/Devel-Declare-Parser-%{version}.tar.gz
Patch0:         perl-Devel-Declare-Parser-fix-dependencies.patch
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(B/Compiling.pm)
BuildRequires:  perl(B/Hooks/EndOfScope.pm)
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Devel/Declare.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(Scalar/Util.pm)
# Tests
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Simple.pm)
Requires:       perl(B/Compiling.pm) >= 0.020
Requires:       perl(B/Hooks/EndOfScope.pm) >= 0.080
Requires:       perl(Devel/Declare.pm) >= 0.006

# Filter unversioned dependencies



Source44: import.info
%filter_from_requires /^perl(B.Compiling.pm)/d
%filter_from_requires /^perl(B.Hooks.EndOfScope.pm)/d
%filter_from_requires /^perl(Devel.Declare.pm)/d

%description
Devel-Declare-Parser is a higher-level API sitting on top of
Devel::Declare. It is used by Devel::Declare::Exporter to simplify
exporting of Devel::Declare magic. Writing custom parsers usualy only
requires subclassing this module and overriding a couple methods.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Devel-Declare-Parser-%{version}
%patch0  -p1
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!.*perl\b}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=%{buildroot} create_packlist=0
# %{_fixperms} %{buildroot}/*

# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
./Build test

%files
%doc README
%{perl_vendor_privlib}/Devel/Declare*

%files tests
%{_libexecdir}/%{name}

%changelog
