%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/Size.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Devel-FindGlobals
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Find global variables and their size
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CN/CNANDOR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module just runs around and over the symbol table, finds global variables,
gets their sizes with Devel::Size, and then prints them out.

find_globals() just finds the globals (and returns a hashref), and
find_globals_sizes() returns the globals and the sizes in a hashref.
print_globals_sizes() prints out that data in a pretty table.

find_globals() hashref is of the form $hash->{TYPE}{NAME}, where TYPE
is SCALAR, ARRAY, HASH (types stored in @Devel::FindGlobals::TYPES).

find_globals_sizes() hashref is the same, except that the value of the
record is not `1' but an arrayref of size and total_size (size is the
size of the variable itself, and total_size counts up all the other
members of the variable, for arrayrefs and hashrefs).

print_globals_sizes() accepts an OPTIONS hash.  Currently recognized
options are:

=over 4

=item * ignore_files

Ignore file globals (like `$main::_</usr/local/lib/perl5/5.8.0/vars.pm').
Default value is true.

=item * ignore_undef_scalars

Ignore scalars that exist, but are not defined.  Default value is true.

=item * exclude_match

An arrayref of strings to match; e.g., ['^VERSION$', '^Debug'].  Will not print
variables matching any of the expressions.

=item * include_match

Same as exclude_match, except for variables to exclusively include, instead of
strings to exclude.

=item * lexicals

A hashref of `name =' reference> for lexical variables to include in the report.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
