%define module_version 0.00003
%define module_name Devel-InheritNamespace
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Load.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Module/Pluggable.pm) perl(Module/Pluggable/Object.pm) perl(Moose.pm) perl(Test/More.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.00003
Release: alt1
Summary: Inherit An Entire Namespace
Group: Development/Perl
License: perl
URL: https://github.com/lestrrat/Devel-InheritNamespace

Source0: http://cpan.org.ua/authors/id/D/DM/DMAKI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
WARNING: YMMV using this module.

This module allows you to dynamically "inherit" an entire namespace.

For example, suppose you have a set of packages under MyApp::Base:

    MyApp::Base::Foo
    MyApp::Base::Bar
    MyApp::Base::Baz

Then some time later you start writing MyApp::Extend.
You want to reuse MyApp::Base::Foo and MyApp::Base::Bar by subclassing
(because somehow the base namespace matters -- say, in Catalyst), but
you want to put a little customization for MyApp::Base::Baz

Normally you achieve this by manually creating MyApp::Extended:: modules:

    # in MyApp/Extended/Foo.pm
    package MyApp::Extended::Foo;
    use Moose;
    extends 'MyApp::Base::Foo';

    # in MyApp/Extended/Bar.pm
    package MyApp::Extended::Bar;
    use Moose;
    extends 'MyApp::Base::Bar';

    # in MyApp/Extended/Baz.pm
    package MyApp::Extended::Baz;
    use Moose;
    extends 'MyApp::Base::Baz';

    ... whatever customization you need ...

This is okay for a small number of modules, or if you are only doing this once
or twice. But perhaps you have tens of these modules, or maybe you do this
on every new project you create to inherit from a base applicatin set.

In that case you can use Devel::InheritNamespace. 


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/D*

%changelog
