%define module_name Devel-KYTProf
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Data/Lite.pm) perl(Class/Inspector.pm) perl(DBD/SQLite.pm) perl(DBIx/Tracer.pm) perl(Module/Build/Tiny.pm) perl(Module/Load.pm) perl(Term/ANSIColor.pm) perl(Test/More.pm) perl(Test/Requires.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9994
Release: alt1
Summary: Simple profiler
Group: Development/Perl
License: perl
URL: https://github.com/onishi/perl5-devel-kytprof

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SO/SONGMU/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Devel::KYTProf is a perl code profiler to explore IO blocking time.

  use Devel::KYTProf;

  # your code ( including DBI, LWP )

Output as follows.

  315.837 ms [DBI::st] select * from table where name = ? (1 rows) | main:23
  1464.204 ms [LWP::UserAgent] GET http://www.hatena.ne.jp/ | main:25

You can add profiler to any method.

  Devel::KYTProf->add_prof($module, $method);
  Devel::KYTProf->add_prof($module, $method, $callback);

  Devel::KYTProf->add_profs($module, $methods);
  Devel::KYTProf->add_profs($module, $methods, $callback);

  Devel::KYTProf->add_profs($module, ':all');
  Devel::KYTProf->add_profs($module, ':all', $callback);

You can change settings.

  Devel::KYTProf->namespace_regex();
  Devel::KYTProf->ignore_class_regex();
  Devel::KYTProf->context_classes_regex();
  Devel::KYTProf->logger($logger);
  Devel::KYTProf->threshold(100); # ms
  Devel::KYTProf->mute($module, $method);
  Devel::KYTProf->unmute($module, $method);
  Devel::KYTProf->remove_linefeed(1);
  Devel::KYTProf->remove_escape_sequences(1);


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/D*

%changelog
