%define module_name Devel-QuickCover
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Data/Dumper.pm) perl(Dumbbench.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Copy.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(IO/Compress/Gzip.pm) perl(IPC/Open2.pm) perl(JSON/MaybeXS.pm) perl(POSIX.pm) perl(Path/Tiny.pm) perl(Sereal.pm) perl(Test/Builder/Module.pm) perl(Test/More.pm) perl(Text/MicroTemplate.pm) perl(XSLoader.pm) perl(autodie.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.900014
Release: alt4
Summary: Quick & dirty code coverage for Perl
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GO/GONZUS/%{module_name}-%{version}.tar.gz

%description
The following program sets up the coverage hook on `use' and dumps
a report (to `/tmp' by default) at the end of execution.

    use Devel::QuickCover;
    my $x = 1;
    my $z = 1 + $x;

The following program sets up the coverage hook on `start()' and
dumps a report to `some_dir' on `end()', at which point
the coverage hook gets uninstalled. So in this case, we only get
coverage information for `bar()'. We also get the specified metadata
in the coverage information. We also ask not to register an atexit()
handler to dump cover data / cleanup; it will be done from `end()'.

    use Devel::QuickCover (
      nostart => 1,
      nodump => 1,
      noatexit => 1,
      output_directory => "some_dir/",
      metadata => { git_tag = "deadbeef" });

    foo();
    Devel::QuickCover::start();
    bar();
    Devel::QuickCover::end();
    baz();

For now, we support calling `start()' only once.

When you call `end()', you can optionally pass a `nodump'
boolean argument, to indicate whether you wish to skip generating
the cover files.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release
BuildArch: noarch

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_archlib/D*
%perl_vendor_autolib/*

%files scripts
%_bindir/*

%changelog
