# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec/Functions.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(Module/Build.pm) perl(Path/Class.pm) perl(String/ShellQuote.pm) perl(Test/More.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 1.00
%define module_name Devel-UseFromCommandLineOnly
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: use a module from the command line only
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MARKF/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module prevents you from loading any subclass of it from anywhere but
the command line.

This is most useful for writing development tools that monkeypatch other people's
code. These hacks are fine to enable from the command line during development,
but you wouldn't want to allow anyone to perminatly install them in any code that
they could ship as the hacks could break at any point.  See the Test::EnhancedIs manpage
as a good example of this.

To use it you simply subclass the module:

  package Foo;
  use base qw(Devel::UseFromCommandLineOnly);

This exposes an `import' routine that checks if you're calling it from a
script or module or from the command line and throws an exception if it's
the former.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_privlib/D*

%changelog
