# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Devel/GlobalDestruction.pm) perl(ExtUtils/MakeMaker.pm) perl(Import/Base.pm) perl(Test/CheckManifest.pm) perl(Test/Script.pm) perl(Test/Warn.pm) perl(Test2/V0.pm) perl(charnames.pm) perl(indirect.pm) perl(namespace/clean.pm) perl(overloading.pm)
# END SourceDeps(oneline)
%define module_name Devel-WatchVars
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.5
Release: alt1
Summary: trace access to scalar variables
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOMC/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
The `Devel::WatchVars' module provides simple tracing of scalars.
The `watch' function takes the scalar you want traced followed by 
the descriptive string to use as its name in traces.

Here's a simple illustration using a short program, here named examples/simple:

     1_#!/usr/bin/env perl
     2_use v5.10;
     3_use strict;
     4_use warnings;
     5_
     6_use Devel::WatchVars;
     7_sub twice { return 2 * shift  }
     8_
     9_my $x = 10;
    10_watch($x, '$x');
    11_say "starting watched value is $x";
    12_$x = 5 + twice(++$x);
    13_say "ending watched value is $x";
    14_unwatch $x;

When run, that produces the following output:

    WATCH $x = 10 at examples/simple line 10.
    FETCH $x --> 10 at examples/simple line 11.
    starting watched value is 10
    FETCH $x --> 10 at examples/simple line 12.
    STORE $x <-- 11 at examples/simple line 12.
    FETCH $x --> 11 at examples/simple line 7.
    STORE $x <-- 27 at examples/simple line 12.
    FETCH $x --> 27 at examples/simple line 13.
    ending watched value is 27
    UNWATCH $x = 27 at examples/simple line 14.

The trace appears on standard error, one line per access
consisting of the following elements:

=over

=item * 

A word in all capital letters for the type of access, one 
of `WATCH', `FETCH', `STORE', `UNWATCH', or `DESTROY'.

=item *

Whatever string you passed in the second argument.
passed the initial call to `watch'.

=item *

A bit of intervening text (`=' or `-->' 
or `<--').

=item * 

The scalar value.

=item *

The origin by file and line.

=back

The first argument to `watch' must be a scalar variable, or a
single scalar element from an array or a hash.  In other words,
that argument needs to begin with a literal dollar sign.

The second argument to `watch' is an arbitrary string.
Normally its the name of that watched scalar, however you
choose to represent that. This can be useful if you just want to
watch one element from some larger data structure. For example,

    watch $nums[2],     "element[2] of array"...

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/D*

%changelog
