%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 1.2.3
%define module_name Device-Davis
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2.3
Release: alt7
Summary: Perl extension for communicating with Davis weather stations
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/ST/STSANDER/%module_name-%module_version.tar.gz

%description
Davis is a Perl 5 module that facilitates communication with Davis weather stations.  This module should work on most unix systems, however it was developed on Linux.  

station_open() takes the tty where the station is connected as an argument and opens the tty with the correct parameters for communication.  The baud rate that is used matches the factory default of the Vantage Pro, which is 19200.  If you need to use a different baud rate, you will need to modify the Davis.xs file before compiling the module.

put_string() takes a file descriptor (NOT a perl filehandle) and the string to send as arguments and sends the string to the weather station.  This function will return the number of bytes written.

get_char() takes a file descriptor as an argument and retuns 1 byte from the weather station.  

crc_accum() is an accumulator for the crc calculation.  It takes the previous value of the crc that has been accumulated ($crc) and the new data byte that needs to be added to the accumulated total.  Be sure to initialize $crc to 0 before sending a new set of data bytes.  The function will return the new accumulated crc value.  Once you pass in the crc value received from the weather station, the function should return a 0 if the crc check passed.  If you are sending commands to the station, the last value returned by the function should be what you send to the station as the crc value.  Note that the station expects the most significant byte of the crc to be sent first, which is opposite of how regular data values are sent.  

put_unsigned() is for sending numeric values to the station.  It takes the file descriptor and the character to send as arguments.  It will send it's argument as a one byte unsigned character.  It will return the number of bytes written. 


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/D*
%perl_vendor_autolib/*

%changelog
