# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Moose.pm) perl(Test/More.pm) perl(XSLoader.pm) perl(blib.pm) perl(constant.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name Device-I2C
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt6
Summary: Control and read hardware devices with i2c(SMBus)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Device-I2C

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SV/SVOLKOV/%{module_name}-%{module_version}.tar.gz

%description
This is a perl interface to I2C interface using libi2c-dev library. 

Prerequisites:

For Debian and derivative distros(including raspbian) use the following to install dependencies:

  sudo apt-get install libi2c-dev i2c-tools build-essential

If you are using Angstrom Linux use the following:

  opkg install i2c-tools
  opkg install i2c-tools-dev

For ArchLINUX use the following steps:

  pacman -S base-devel
  pacman -S i2c-tools

Special Instructions for enabling the I2C driver on a Raspberry Pi:

You will need to comment out the driver from the blacklist. currently the
I2C driver isn't being loaded.

     sudo vim /etc/modprobe.d/raspi-blacklist.conf

Replace this line 

     blacklist i2c-bcm2708

with this

     #blacklist i2c-bcm2708

You now need to edit the modules conf file.

     sudo vim /etc/modules

Add these two lines;

     i2c-dev
     i2c-bcm2708

Now run this command(replace 1 with 0 for older model Pi)

     sudo i2cdetect -y 1

If that doesnt work on your system you may alternatively use this:

     sudo i2cdetect -r 1

you should now see the addresses of the i2c devices connected to your i2c bus
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_archlib/D*
%perl_vendor_autolib/*

%changelog
