# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Device-MAC
%define upstream_version 1.00

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_13

Summary:    Handle hardware MAC Addresses (EUI-48 and EUI-64)
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Device/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Class/Accessor/Grouped.pm)
BuildRequires: perl(Device/OUI.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Sub/Exporter.pm)
BuildRequires: perl(Test/Most.pm)
BuildRequires: perl(ok.pm)
BuildArch: noarch
Source44: import.info

%description
This module provides an interface to deal with Media Access Control (or
MAC) addresses. These are the addresses that uniquely identify a device on
a network. Although the common case is hardware addresses on network cards,
there are a variety of devices that use this system. This module supports
both EUI-48 and EUI-64 addresses.

Some devices that use EUI-48 (or MAC-48) addresses include:

    Ethernet
    802.11 wireless networks
    Bluetooth
    IEEE 802.5 token ring
    FDDI
    ATM

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml README
%perl_vendor_privlib/*




%changelog
