# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(Moose.pm) perl(Moose/Exporter.pm)
# END SourceDeps(oneline)
%define module_name Device-NTCChip-GPIO
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.101
Release: alt1
Summary: Control the GPIO pins on the original NTC Chip
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MQ/MQTECH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides method to control the GPIO pins on the original NTC Chip.  It first scans the
/sys/class/gpio location to map the GPIO addresses, then provides methods to turn the pins on or off
or read them.

    use Device::NTCChip::GPIO;

    # Initialise the GPIO interface
    my $gpio = Device::NTCChip::GPIO->new;

    # take the appropriate action
    if ( $action eq "on" ){
        $gpio->relay_on($pin);
    } elsif ( $action eq "off" ){
        $gpio->relay_off($pin);
    } else {
        my $error = "Unknown facility mode: $action";
        die $error;
    }

NTC has gone into liquidation since this module was first written, but it is being made available in the
hope it will be of some use to somebaody.  No original NTC domains exist anymore, but there is this 
community site that provide a lot of info: http://www.chip-community.org/index.php/Main_Page.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md README.mkdn LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
