# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(AnyDBM_File.pm) perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(IO/File.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(overload.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Device-OUI
%define upstream_version 1.04

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_13

Summary:    Resolve an Organizationally Unique Identifier
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Device/%{upstream_name}-%{upstream_version}.tar.gz
Patch0:     Device-OUI-1.04-hash.patch

BuildRequires: perl(Class/Accessor/Grouped.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(Sub/Exporter.pm)
BuildRequires: perl(Test/Exception.pm)
BuildArch: noarch
Source44: import.info

%description
This module provides an interface to the IEEE OUI (Organizationally Unique
Identifier) registry. The registry contains information on what company an
OUI is assigned to. OUIs are used in various networking devices as part of
a unique ID method (network MAC addresses and Fiber Channel WWNs in
particular, see the the Device::MAC manpage and the Device::WWN manpage
modules for more information).

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
%patch0 -p1


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
make test

%install
%makeinstall_std

%files
%doc Changes META.yml README
%perl_vendor_privlib/*


%changelog
