# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Digest-SHA-PurePerl
%define upstream_version 6.04

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Perl implementation of SHA-1/224/256/384/512
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/authors/id/M/MS/MSHELOR/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(FileHandle.pm)
BuildRequires: perl-devel
BuildArch:  noarch

Conflicts:   perl-Digest-SHA < 5.610.0-2.mga
Source44: import.info

%description
Digest::SHA::PurePerl is a complete implementation of the NIST
Secure Hash Standard.  It gives Perl programmers a convenient way
to calculate SHA-1, SHA-224, SHA-256, SHA-384, and SHA-512 message
digests.  The module can handle all types of input, including
partial-byte data.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor -d
%make_build

%check
%{__make} test

%install
%makeinstall_std

%files
%doc Changes META.yml  README examples
%{perl_vendor_privlib}/Digest/SHA/PurePerl.pm
%{_mandir}/man1/*
%{_bindir}/*

%changelog
