# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Digest/MD5.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_version 1.00
%define module_name Digest-TransformPath
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: Implements the TransformPath concept
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADAMK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
A TransformPath is a complex higher-order key that is designed for use with
chains of functions that sequentially transform a piece of data.

The concept starts with a sizable chunk of data, for example an image, for
which we can determine a unique identifier, and for which we can cheaply
determine if and when the source material has changed.

A series of resource-intensive transforms might be applied to this original
data to produce another piece of data. In the image example, we might
auto-level, crop, scale, rotate, colour-balance and then thumbnail the
image. This transformed data would be put into a cache.

If at some future point we wish to obtain the same image, but would
preferably like to use the cached version, we would have to take the original
image, reapply the transforms, and then compare to the result the first time
around.

Alternatives to this general checking mechanism revolve around storing the
identifier in parellel to the data file, in a database or data file, or
similar schemes the involve similar amounts of complexity.

In the TransformPath concept, a structure is created which contains the
original source identifier, and a short, ordered and unique description of
all of the transformations in the sequence.

This description structure is then serialised and hashed to get a unique and
generally cryptographically secure identifier for the transformed image. This
identifier would typically be used as part of the file name/path for the
transformed image.

To check that the file is unchanged, we merely confirm that the original has
not changed, and then rebuilt the TransformPath digest. If the TransformPath
digest is unchanged, then the transformed image is unchanged, and we can use
the version in the cache, saving ourselves the high expense of running the
transforms again.

If we cannot cheaply tell that the source image has changed, there is a
clean fallback position. By including a digest of the original data inside
the TransformPath object, the final digest changes automatically whenever the
data inside the source file changes.

While this still costs us a digest run each time, this is relatively
affordable compared to doing the transforms as well.

This can be done by either using the initial digest as the source id, or by
adding it as the first transform step. The latter is recommended for most
situations, as this ensures that the source id is static, and won't change.

In many uses of Digest::TransformPath, this is likely to be highly preferable.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/D*

%changelog
