%define module_name DigitalOcean
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/XS.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Mouse.pm) perl(Mouse/Util/TypeConstraints.pm) perl(Object/Tiny/XS.pm) perl(Test/More.pm) perl(constant.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: An OO interface to the Digital Ocean API.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SR/SRCHULO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is an object oriented interface into the Digital Ocean API.

    use DigitalOcean;

    #for more efficient use, remove "wait_on_events => 1". See WAITING ON EVENTS section for more info
    my $do = DigitalOcean->new(client_id=> $client_id, api_key => $api_key, wait_on_events => 1);

    for my $droplet (@{$do->droplets}) { 
        print "Droplet " . $droplet->name . " has id " . $droplet->id . "\n";
    }

    my $droplet = $do->droplet($droplet_id);
    $droplet->reboot;
    $droplet->power_off;
    $droplet->power_on;
    $droplet->destroy;

    my $new_droplet = $do->create_droplet(
        name => 'new_droplet',
        size_id => $size_id,
        image_id => $image_id,
        region_id => $region_id,
    );

    $new_droplet->enable_backups;


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/D*

%changelog
