# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Tar.pm) perl(Config.pm) perl(Dist/Zilla/Role/ArchiveBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(Path/Tiny.pm) perl(Test/DZil.pm) perl(Test2/V0.pm) perl(experimental.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_name Dist-Zilla-Plugin-ArchiveTar
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Create dist archives using  Archive::Tar
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Dist::Zilla::Plugin::ArchiveTar

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This the Dist::Zilla manpage plugin overrides the build in archive builder and uses the Archive::Tar manpage only.
Although the Dist::Zilla manpage does frequently use the Archive::Tar manpage itself, it is different from the built
in version in the following ways:

=over 4

=item Predictable

The built in behavior will sometimes use the Archive::Tar manpage or the Archive::Tar::Wrapper manpage.  The problem with the Archive::Tar::Wrapper manpage
is that it depends on the system implementation of tar, which in some cases can produce archives that are not readable by older
implementations of tar.  In particular GNU tar which is typically the default on Linux systems includes unnecessary features that
break tar on HP-UX.  (You should probably be getting off HP-UX if you are still using it in 2021 as I write this).

=item Sorted by name

The contents of the archive are sorted by name instead of being sorted by filename length.  While sorting by length makes for
a pretty display when they are unpacked, I find it harder to find stuff when the content is listed.

=item Additional formats

This plugin supports the use of compression formats supported by the Archive::Tar manpage.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README author.yml Changes LICENSE
%perl_vendor_privlib/D*

%changelog
