%define module_name Dist-Zilla-Plugin-Beam-Connector
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Beam/Emitter.pm) perl(Beam/Event.pm) perl(Beam/Wire.pm) perl(Carp.pm) perl(Dist/Zilla/File/InMemory.pm) perl(Dist/Zilla/Plugin/MakeMaker.pm) perl(Dist/Zilla/Role/Plugin.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(List/Util.pm) perl(Moose.pm) perl(MooseX/LazyRequire.pm) perl(Path/Tiny.pm) perl(Test/DZil.pm) perl(Test/More.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001003
Release: alt1
Summary: Connect events to listeners in Dist::Zilla plugins.
Group: Development/Perl
License: perl
URL: https://github.com/kentnl/Dist-Zilla-Plugin-Beam-Connector

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KE/KENTNL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module aims to allow `Dist::Zilla' to use plugins
using `Beam::Event' and `Beam::Emitter',
and perhaps reduce the need for massive amounts of composition and role application
proliferating `CPAN'.

This is in lieu of a decent dependency injection system, and is presently relying
on `Dist::Zilla' to load and construct the plugins itself, and then you just connect
the plugins together informally, without necessitating each plugin be specifically
tailored to the recipient.

Hopefully, this may also give scope for non-`dzil' plugins being loadable into memory
some day, and allowing message passing of events to those plugins. ( Hence, the `plugin:' prefix )

A Real World Example of what a future could look like?

  [GatherDir]

  [Test::Compile]

  [Beam::Connector]
  on = plugin:GatherDir#collect => plugin:Test::Compile#generate_test

`GatherDir' in this example would build a mutable tree of files,
attach them to an event `::GatherDir::Tree', and pass that event to `Test::Compile#generate_test',
which would then add ( or remove, or mutate ) any files in that tree.

Tree state mutation then happens in order of prescription, in the order given
by the various `on' declarations.

Thus, a single plugin can be in 2 places in the same logical stage.

  [Beam::Connector]
  on = plugin:GatherDir#collect => plugin:Test::Compile#generate_test
  ; lots more collectors here
  on = plugin:GatherDir#collect => plugin:Test::Compile#finalize_test

Whereas presently, order of affect is either governed by:

=over 4

=item * phase - where you can add but not remove or mutate, mutate but not add or remove, remove, but not add or mutate

=item * plugin order - where a single plugin cant be both early in a single phase and late

=back

If that example is not convincing enough for you, consider all the different ways
there are presently for implementing `[MakeMaker]'. If you're following the standard logic
its fine, but as soon as you set out of the box, you have a few things you're going to have to do instead:

=over 4

=item ...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE examples
%perl_vendor_privlib/D*

%changelog
