# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dist/Zilla/Role/AfterBuild.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Moose.pm) perl(Path/Tiny.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Types/Standard.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_name Dist-Zilla-Plugin-CheckForUnwantedFiles
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0100
Release: alt1
Summary: Check for unwanted files
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Dist-Zilla-Plugin-CheckForUnwantedFiles

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CS/CSSON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin checks the development directory (not the build directory) for unwanted files. This is useful when, for instance, switching CI providers, and you don't
want to have the previous provider's configuration files lingering around and you are too forgetful to remember to check for them
when doing a new release after the switch.

It is run at the `AfterBuild' stage, and takes one (repeatable) argument: `unwanted_file'. It is a fatal error if any unwanted file is found.
And, despite its name, it works just as well with unwanted directories.

So:

=over 4

=item 1

Remove the plugin that generates the file from the bundle

=item 2

Add this plugin to the bundle

=item 3

Add the path to the file gets generated as an `unwanted_file'

=item 4

You must delete the unwanted file before the distribution can be built

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/D*

%changelog
