# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta/Prereqs.pm) perl(CPAN/Meta/Requirements.pm) perl(Dist/Zilla/Role/MetaProvider.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Path/Tiny.pm) perl(Test/DZil.pm) perl(Test/Deep.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(if.pm) perl(namespace/autoclean.pm) perl(Dist/Zilla/Role/ModuleMetadata.pm)
# END SourceDeps(oneline)
%define module_version 0.011
%define module_name Dist-Zilla-Plugin-CheckSelfDependency
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.011
Release: alt1
Summary: Check if your distribution declares a dependency on itself
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/ET/ETHER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
=for Pod::Coverage after_build

=for stopwords indexable

This is a the Dist::Zilla manpage plugin that runs in the *after build* phase, which
checks all of your module prerequisites (all phases, all types except develop) to confirm
that none of them refer to modules that are provided by this distribution
(that is, the metadata declares the module is indexable).

In addition, all modules in the distribution are checked against all module
prerequisites (all phases, all types including develop). Thus, it is
possible to ship a the Dist::Zilla manpage plugin and use (depend on) yourself, but
errors such as declaring a dependency on `inc::HelperPlugin' are still caught.

While some prereq providers (e.g. `[AutoPrereqs]')
do not inject dependencies found internally, there are many plugins that
generate code and also inject the prerequisites needed by that code, without
regard to whether some of those modules might be provided by your dist.
This problem is particularly acute when packaging low-level toolchain distributions.

If such modules are found, the build fails.  To remedy the situation, remove
the plugin that adds the prerequisite, or remove the prerequisite itself with
`[RemovePrereqs]'. (Remember that
plugin order is significant -- you need to remove the prereq after it has been
added.)


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/D*

%changelog
