%define module_name Dist-Zilla-Plugin-Code
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(Config/MVP.pm) perl(Cwd.pm) perl(Dist/Zilla/File/InMemory.pm) perl(Dist/Zilla/Role/AfterBuild.pm) perl(Dist/Zilla/Role/AfterRelease.pm) perl(Dist/Zilla/Role/BeforeArchive.pm) perl(Dist/Zilla/Role/BeforeBuild.pm) perl(Dist/Zilla/Role/BeforeRelease.pm) perl(Dist/Zilla/Role/BuildRunner.pm) perl(Dist/Zilla/Role/EncodingProvider.pm) perl(Dist/Zilla/Role/FileFinder.pm) perl(Dist/Zilla/Role/FileFinderUser.pm) perl(Dist/Zilla/Role/FileGatherer.pm) perl(Dist/Zilla/Role/FileMunger.pm) perl(Dist/Zilla/Role/FilePruner.pm) perl(Dist/Zilla/Role/InstallTool.pm) perl(Dist/Zilla/Role/LicenseProvider.pm) perl(Dist/Zilla/Role/MetaProvider.pm) perl(Dist/Zilla/Role/NameProvider.pm) perl(Dist/Zilla/Role/Plugin.pm) perl(Dist/Zilla/Role/PluginBundle.pm) perl(Dist/Zilla/Role/PluginBundle/Easy.pm)
BuildRequires: perl(Dist/Zilla/Role/PrereqSource.pm) perl(Dist/Zilla/Role/ReleaseStatusProvider.pm) perl(Dist/Zilla/Role/Releaser.pm) perl(Dist/Zilla/Role/TestRunner.pm) perl(Dist/Zilla/Role/VersionProvider.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(Moose.pm) perl(MooseX/Types/Moose.pm) perl(Test/DZil.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(lib.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.008
Release: alt1
Summary: dynamically create plugins from a bundle
Group: Development/Perl
License: open_source
URL: https://github.com/skirmess/Dist-Zilla-Plugin-Code

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SK/SKIRMESS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
=over 4

=item the Dist::Zilla::Plugin::Code::AfterBuild manpage

something that runs after building is mostly complete

=item the Dist::Zilla::Plugin::Code::AfterRelease manpage

something that runs after release is mostly complete

=item the Dist::Zilla::Plugin::Code::BeforeArchive manpage

something that runs before the archive file is built

=item the Dist::Zilla::Plugin::Code::BeforeBuild manpage

something that runs before building really begins

=item the Dist::Zilla::Plugin::Code::BeforeRelease manpage

something that runs before release really begins

=item the Dist::Zilla::Plugin::Code::BuildRunner manpage

something used as a delegating agent during 'dzil run'

=item the Dist::Zilla::Plugin::Code::EncodingProvider manpage

something that sets a files' encoding

=item the Dist::Zilla::Plugin::Code::FileFinder manpage

something that finds files within the distribution

=item the Dist::Zilla::Plugin::Code::FileGatherer manpage

something that gathers files into the distribution

=item the Dist::Zilla::Plugin::Code::FileMunger manpage

something that munges files within the distribution

=item the Dist::Zilla::Plugin::Code::FilePruner manpage

something that prunes files from the distribution

=item the Dist::Zilla::Plugin::Code::Initialization manpage

something that runs when plugins are initialized

=item the Dist::Zilla::Plugin::Code::InstallTool manpage

something that creates an install program for a dist

=item the Dist::Zilla::Plugin::Code::LicenseProvider manpage

something that offers a license for a dist

=item the Dist::Zilla::Plugin::Code::MetaProvider manpage

something that provides data to merge into the distribution metadata

=item the Dist::Zilla::Plugin::Code::NameProvider manpage

something that provides a name for the dist

=item the Dist::Zilla::Plugin::Code::PrereqSource manpage

something that registers prereqs of the dist

=item the Dist::Zilla::Plugin::Code::ReleaseStatusProvider manpage

something that provides a release status for the dist

=item the Dist::Zilla::Plugin...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING README LICENSE
%perl_vendor_privlib/D*

%changelog
