# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-Conflicts
%define upstream_version 0.20

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Declare conflicts for your distro
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/CheckConflicts.pm)
BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(Dist/Zilla/File/FromCode.pm)
BuildRequires: perl(Dist/Zilla/File/InMemory.pm)
BuildRequires: perl(Dist/Zilla/Role/FileGatherer.pm)
BuildRequires: perl(Dist/Zilla/Role/InstallTool.pm)
BuildRequires: perl(Dist/Zilla/Role/MetaProvider.pm)
BuildRequires: perl(Dist/Zilla/Role/PrereqSource.pm)
BuildRequires: perl(Dist/Zilla/Role/TextTemplate.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/pushd.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Test/DZil.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/Differences.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Requires.pm)
BuildRequires: perl(if.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This module lets you declare conflicts on other modules (usually
dependencies of your module) in your _dist.ini_.

Declaring conflicts does several thing to your distro.

First, it generates a module named something like
'Your::Distro::Conflicts'. This module will use the Dist::CheckConflicts
manpage to declare and check conflicts. The package name will be obscured
from PAUSE by putting a newline after the 'package' keyword.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes INSTALL LICENSE META.json META.yml 
%{perl_vendor_privlib}/*

%changelog
