# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/Kwalitee.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(autodie.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-CopyFilesFromBuild
%define upstream_version 0.170880

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Copy (or move) specific files after building (for SCM inclusion, etc.)
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Dist/Zilla/Plugin/ReadmeAnyFromPod.pm)
BuildRequires: perl(Dist/Zilla/Role/AfterBuild.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(MooseX/Has/Sugar.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Set/Scalar.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Most.pm)
BuildRequires: perl(blib.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(utf8.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This plugin will automatically copy the files that you specify in dist.ini
from the build directory into the distribution directory. This is so you
can commit them to version control.

If you want to put a build-generated file in version control but you
_don't_ want it to _remain_ in the build dir, use 'move' instead of 'copy'.
When you use 'move', the _MANIFEST_ file will be updated if it exists, and
the moved files will be pruned from their former location.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes INSTALL LICENSE META.json META.yml  README
%{perl_vendor_privlib}/*


%changelog
