# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dist/Zilla.pm) perl(Dist/Zilla/Role/FileFinderUser.pm) perl(Dist/Zilla/Role/FileMunger.pm) perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(Object/Pad.pm) perl(Test/DZil.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_name Dist-Zilla-Plugin-ExplicitPackageForClass
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: Insert an explicit package statement for class declarations
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AJ/AJNN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
During the build, this FileMunger
plugin for the Dist::Zilla manpage will look through your code for
`class' and `role' declarations and insert
a corresponding `package' statement before
them, along with the package version.

If you've tried the the perlclass manpage feature (also known as "Corinna")
introduced with Perl_v5.38, you may have run into problems with
the toolchain. Corinna defines new keywords such as `class' that
can replace keywords like `package' in modern code. Unfortunately,
as of 2023, many tools used by developers to process Perl module
distributions don't expect that Perl namespaces are declared
by any other keyword than `package'. Even Dist::Zilla itself
is affected, as is the PPI manpage, which is used by a number of
Dist::Zilla plugins, leading to the possibility of error messages
like these for files that declare namespaces with `class':

  [PkgVersion] skipping lib/Foo/Bar.pm: no package statement found
  [MetaProvides::Package] No namespaces detected in file lib/Foo/Baz.pm
  ... and so on

the section on "File Layout" in the Object::Pad manpage suggests that the `class' declaration
should be preceded by a `package' statement until toolchain
modules catch up. But manually duplicating the package name not
only looks ugly, it's also a chore and a possible source of bugs.
That's why this plugin will insert a `package' statement for you
automatically before every `class' / `role' declaration.

The insertion only happens in the built distribution. The Perl
source files in your working directory will never be touched by
this plugin.

To ensure that line numbers won't change, it's required that the
line before the `class' declaration is empty in your source file.
The empty line will be replaced with a `package NAMESPACE VERSION'
statement by this plugin. Because that already includes the module
version, use of the PkgVersion
plugin alongside this plugin should be avoided (or at least, custom
file finders should be used to avoid that both of them work on the
same files).

This plugin wil...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
