%define module_name Dist-Zilla-Plugin-GenPericmdScript
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/GenPericmdCompleterScript.pm) perl(Dist/Zilla/File/InMemory.pm) perl(Dist/Zilla/Role/FileFinderUser.pm) perl(Dist/Zilla/Role/FileGatherer.pm) perl(Dist/Zilla/Role/FileMunger.pm) perl(Dist/Zilla/Role/PERLANCAR/WriteModules.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Load.pm) perl(Moose.pm) perl(Perinci/CmdLine/Gen.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.425
Release: alt1
Summary: Generate Perinci::CmdLine script
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Dist-Zilla-Plugin-GenPericmdScript

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
After you add the Rinci manpage metadata to your function, e.g.:

 package My::Palindrome;
 $SPEC{check_palindrome} = {
     v => 1.1,
     args => {
         text => { schema=>'str*', req=>1, pos=>0 },
         ci   => { schema=>'bool*', cmdline_aliases=>{i=>{}} },
     },
     result_naked => 1,
 };
 sub check_palindrome {
     my %%args = @_;
     my $text = $args{ci} ? lc($args{text}) : $args{text};
     $text eq reverse($text);
 }

you can create a command-line script for that function that basically is not
much more than:

 #!perl
 use Perinci::CmdLine::Any;
 Perinci::CmdLine::Any->new(url => '/My/Palindrome/check_palindrome');

This Dist::Zilla plugin lets you automate the creation of such scripts.

Creating scripts. To create a single script, put this in `dist.ini':

 [GenPericmdScript]
 ;required
 url=/My/Palindrome/check_palindrome
 ;optional
 abstract=Check if a text is a palindrome
 ; ...

To create more scripts, load the plugin again using the `[Plugin/Name]' syntax,
e.g.:

 [GenPericmdScript / GenAnotherScript]
 ...

=for Pod::Coverage .+
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
