%define module_name Dist-Zilla-Plugin-Git-FilePermissions
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(Dist/Zilla/Plugin/Git/GatherDir.pm) perl(Dist/Zilla/Role/BeforeBuild.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(Git/Background.pm) perl(Moose.pm) perl(Path/Tiny.pm) perl(Test/DZil.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(lib.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.002
Release: alt1
Summary: fix the file permissions in your Git repository with Dist::Zilla
Group: Development/Perl
License: open_source
URL: https://github.com/skirmess/Dist-Zilla-Plugin-Git-FilePermissions

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SK/SKIRMESS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin fixes the file permissions of all the files in the Git repository
where your project is saved. Files not in the Git index, and directories, are
ignored.

Without configuration, every file is changed to the default permission of
0644. You can configure different permissions for some files with the
perms argument in the dist.ini.

The plugin runs in the before build phase, which means it will fix the file
permissions before the files are picked up in the file gather phase. The new
permissions are therefore also the ones used in the build.

The plugin should ensure that you always commit your files with the correct
permissions.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes CONTRIBUTING README
%perl_vendor_privlib/D*

%changelog
