%define module_name Dist-Zilla-Plugin-Git-RequireUnixEOL
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(Dist/Zilla/Plugin/Git/GatherDir.pm) perl(Dist/Zilla/Role/BeforeBuild.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(Git/Background.pm) perl(Moose.pm) perl(Path/Tiny.pm) perl(Test/DZil.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(lib.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.001
Release: alt1
Summary: Enforce the correct line endings in your Git repository with Dist::Zilla
Group: Development/Perl
License: open_source
URL: https://github.com/skirmess/Dist-Zilla-Plugin-Git-RequireUnixEOL

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SK/SKIRMESS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin checks that all the files in the Git repository where your
project is saved use Unix line endings and have no whitespace at the end of
a line. Files not in the Git index are ignored.

The plugin runs in the before build phase and aborts the build if a violation
is found.

The plugin should ensure that you always commit your files with the correct
line endings and without superfluous whitespace.

This plugin checks the files in your repository. To check your build you can
use a test based on Test::EOL.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE CONTRIBUTING
%perl_vendor_privlib/D*

%changelog
