# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Moose.pm) perl(Scalar/Util.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-LatestPrereqs
%define upstream_version 0.4

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Adjust prereqs to use latest version available
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(CPAN.pm)
BuildRequires: perl(CPAN/Meta/Prereqs.pm)
BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Module/CoreList.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This plugin will filter over all your declared or discovered prerequisites,
contact CPAN, and adjust the version to the latest one available.

This will make sure that your module will be installed with the latest
version available on CPAN at the time you built your package.

The most common use for this technique is for Task modules.
You can rebuild your Task module on a regular basis to make sure it has the
latest versions of your dependencies.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes INSTALL LICENSE META.json META.yml README
%perl_vendor_privlib/*


%changelog
