# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Moose.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/CPAN/Meta.pm) perl(Test/Fatal.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-MakeMaker-SkipInstall
%define upstream_version 1.201

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Skip the install rule of MakeMaker
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(Dist/Zilla/Plugin/CheckChangeLog.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This small plugin will edit the 'Makefile.PL' file, and override the
install target to become a no-op.

This will make your module fail the install phase. It will be built, and
tested but will never be installed.

The most common use for this technique is for Task modules.
Without a proper install phase, you can install your Task module repeatedly.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.yml README
%{perl_vendor_privlib}/*


%changelog
