# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-MetaResourcesFromGit
%define upstream_version 1.103620

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Metadata resource URLs from Git configuration
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Config/INI/Reader.pm)
BuildRequires: perl(Dist/Zilla/Plugin/MetaResources.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Path/Class.pm)
BuildRequires: perl(String/Formatter.pm)
BuildArch: noarch
Source44: import.info

%description
This plugin is a drop-in replacement for the
Dist::Zilla::Plugin::MetaResources manpage for users of Git. It
_automatically_ provides three resource links to your distribution
metadata, based on the name of the distribution and the remote URL of the
Git repository you are working from.

The default links are equivalent to:

 homepage        = https://github.com/%a/%r/wiki
 bugtracker.web  = https://rt.cpan.org/Public/Dist/Display.html?Name=%N
 repository.url  = git://github.com/%a/%r.git
 repository.web  = https://github.com/%a/%r
 repository.type = git

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README Changes LICENSE META.yml META.json
%perl_vendor_privlib/*




%changelog
