# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Moose.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-NoAutomatedTesting
%define upstream_version 0.08

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_8

Summary:    Avoid running under CPAN Testers
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch:  noarch
Source44: import.info

%description
CPAN Testers are great and do a worthy and thankless job, testing all the
distributions uploaded to CPAN. But sometimes we don't want a distribution
to be tested by these gallant individuals.

Dist::Zilla::Plugin::NoAutomatedTesting is a Dist::Zilla plugin
that mangles 'Makefile.PL' to detect that it is being run by a CPAN Tester
and 'exit 0' if it is.

As this plugin mangles the 'Makefile.PL' it is imperative that it is
specified in 'dist.ini' AFTER '[MakeMaker]'.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*


%changelog
