# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Deep.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-ReportVersions-Tiny
%define upstream_version 1.12

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Reports dependency versions during testing
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(Dist/Zilla/File/FromCode.pm)
BuildRequires: perl(Dist/Zilla/Role/FileGatherer.pm)
BuildRequires: perl(Dist/Zilla/Role/PrereqSource.pm)
BuildRequires: perl(Dist/Zilla/Role/TextTemplate.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Test/Differences.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/MockObject.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Warn.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(version.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This module integrates with the Dist::Zilla manpage to automatically add an
additional test to your released software. Rather than testing features of
the software, this reports the versions of all static module dependencies,
and of Perl, at the time the tests are run.

The value of this is that when someone submits a test failure report you
can see which versions of the modules were installed and, hopefully, be
able to reproduce problems that are dependent on a specific set of module
versions.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%{perl_vendor_privlib}/*

%changelog
