# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dmp.pm) perl(Data/Sah.pm) perl(Data/Sah/Normalize.pm) perl(Data/Sah/Resolve.pm) perl(Data/Sah/Util/Subschema.pm) perl(Dist/Zilla/File/InMemory.pm) perl(Dist/Zilla/Role/CheckPackageDeclared.pm) perl(Dist/Zilla/Role/FileFinderUser.pm) perl(Dist/Zilla/Role/FileGatherer.pm) perl(Dist/Zilla/Role/FileMunger.pm) perl(Dist/Zilla/Role/PrereqSource.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Moose.pm) perl(PMVersions/Util.pm) perl(Pod/Coverage/TrustPod.pm) perl(Require/Hook/Source/DzilBuild.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Dist-Zilla-Plugin-Sah-SchemaBundle
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.034
Release: alt1
Summary: Plugin to use when building Sah-SchemaBundle-* distribution
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Dist-Zilla-Plugin-Sah-SchemaBundle

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin is to be used when building `Sah-SchemaBundle-*' distribution.

It adds xt/release/sah-schema.t which does the following:

=over

=item * Check that schema is already normalized

=item * Test examples in schema

=back

It does the following to every `lib/Sah/SchemaBundle/*' .pm file:

=over

=item *

=back

It does the following to every `lib/Sah/Schema/*' .pm file:

=over

=item * Set module abstract from the schema's summary

=item * Add a prereq to other Sah::Schema::* module if schema depends on those other schemas

=item * Produce pre-resolved editions of schemas into `lib/Sah/SchemaR/*'

These are useful if a client wants to lookup the base type of a schema without
having to do any extra resolving. Currently the Perinci::Sub::Complete manpage uses this
to reduce startup overhead when doing tab completion.

=back

=for Pod::Coverage .+

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
