# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-SvnObtain
%define upstream_version 0.02

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Obtain files from a subversion repository before building a distribution
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Cwd.pm)
BuildRequires: perl(Dist/Zilla/Role/BeforeBuild.pm)
BuildRequires: perl(Dist/Zilla/Role/Plugin.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(SVN/Client.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildArch: noarch
Source44: import.info


%description
Uses the SVN::Client manpage to obtain files from a subversion repository
for inclusion in a distribution made with the Dist::Zilla manpage.

'[SvnObtain]' sections in your _dist.ini_ file describe a set of Subversion
repositories that will be downloaded into the current directory prior to
building a distribution. Subdirectories will be created that correspond to
the name of the projects listed in that section. Optionally, after the URL
of the subversion repository, you may specify a particular revision to
check out. If you do not specify a revision, 'HEAD' will be used. For
instance, to include a copy MIT's simile timeline widget into your
distribution, your _dist.ini_ would contain something like this:

  [SvnObtain]
    simile = http://simile-widgets.googlecode.com/svn

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc META.yml LICENSE README
%perl_vendor_privlib/*

%changelog
