# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl(Test/Vars.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-Test-UnusedVars
%define upstream_version 2.001001

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Release tests for unused variables
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildConflicts: cpanminus

BuildRequires: perl(Data/Section.pm)
BuildRequires: perl(Dist/Zilla/File/InMemory.pm)
BuildRequires: perl(Dist/Zilla/Role/FileGatherer.pm)
BuildRequires: perl(Dist/Zilla/Role/PrereqSource.pm)
BuildRequires: perl(Dist/Zilla/Role/TextTemplate.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Module/Build/Tiny.pm)
BuildRequires: perl(Module/Metadata.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Sub/Exporter/ForMethods.pm)
BuildRequires: perl(Test/DZil.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Output.pm)
BuildRequires: perl(autodie.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch

Obsoletes:  perl-Dist-Zilla-Plugin-UnusedVarsTests < 2.0.0
Provides:   perl-Dist-Zilla-Plugin-UnusedVarsTests
Source44: import.info

%description
This is an extension of the Dist::Zilla::Plugin::InlineFiles manpage,
providing the following file:

  xt/release/unused-vars.t - a standard Test::Vars test

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CONTRIBUTING Changes INSTALL LICENCE META.json META.yml  README
%{perl_vendor_privlib}/*

%changelog
