# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-Twitter
%define upstream_version 0.026

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_7

Summary:    Twitter when you release with Dist::Zilla
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Config/INI/Reader.pm)
BuildRequires: perl(Config/INI/Writer.pm)
BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(Dist/Zilla/App/Tester.pm)
BuildRequires: perl(Dist/Zilla/Role/AfterRelease.pm)
BuildRequires: perl(Dist/Zilla/Role/Releaser.pm)
BuildRequires: perl(Dist/Zilla/Role/TextTemplate.pm)
BuildRequires: perl(Dist/Zilla/Tester.pm)
BuildRequires: perl(Dist/Zilla/Util.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(HTTP/Response.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Net/Twitter.pm)
BuildRequires: perl(PPI/Document.pm)
BuildRequires: perl(Params/Util.pm)
BuildRequires: perl(Pod/Eventual.pm)
BuildRequires: perl(Sub/Exporter.pm)
BuildRequires: perl(Term/Encoding.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(WWW/Shorten.pm)
BuildRequires: perl(WWW/Shorten/Simple.pm)
BuildRequires: perl(WWW/Shorten/TinyURL.pm)
BuildRequires: perl(base.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(utf8.pm)
BuildRequires: perl(warnings.pm)

BuildConflicts: cpanminus

BuildArch:  noarch
Source44: import.info

%description
This plugin will use the Net::Twitter manpage with the login and password
in your '.netrc' file to send a release notice to Twitter. By default, it
will include a link to your README file as extracted on a fast CPAN mirror.
This works very nicely with the Dist::Zilla::Plugin::ReadmeFromPod manpage.

The default configuration is as follows:

   [Twitter]
   tweet_url = http://cpan.cpantesters.org/authors/id/{{$AUTHOR_PATH}}/{{$DIST}}-{{$VERSION}}.readme
   tweet = Released {{$DIST}}-{{$VERSION}} {{$URL}}

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%{perl_vendor_privlib}/*


%changelog
