# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-UploadToGoogleCode
%define upstream_version 0.004

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Upload your dist to Google Code (experimental)
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(CPAN/Changes.pm)
BuildRequires: perl(Config/Identity.pm)
BuildRequires: perl(Dist/Zilla/File/OnDisk.pm)
BuildRequires: perl(Dist/Zilla/Role/BeforeRelease.pm)
BuildRequires: perl(Dist/Zilla/Role/Releaser.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(File/pushd.pm)
BuildRequires: perl(Google/Code/Upload.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Util/TypeConstraints.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch: noarch
Source44: import.info

%description
This plugin looks for the Google Code project name in _dist.ini_, and gets
your Google Code credentials from _~/.googlecode-identity_ (which can be
GnuPG-encrypted; see the Config::Identity manpage).

If any configuration is missing, it will prompt you to enter your username
and password during the BeforeRelease phase. Entering a blank username or
password will abort the release.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc META.json META.yml LICENSE Changes README.mkdn
%{perl_vendor_privlib}/*


%changelog
