%define module_name Dist-Zilla-Plugin-VerifyPhases
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Digest/MD5.pm) perl(Dist/Zilla/File/InMemory.pm) perl(Dist/Zilla/Role/AfterBuild.pm) perl(Dist/Zilla/Role/AfterRelease.pm) perl(Dist/Zilla/Role/BeforeBuild.pm) perl(Dist/Zilla/Role/BeforeRelease.pm) perl(Dist/Zilla/Role/EncodingProvider.pm) perl(Dist/Zilla/Role/FileGatherer.pm) perl(Dist/Zilla/Role/FileInjector.pm) perl(Dist/Zilla/Role/FileMunger.pm) perl(Dist/Zilla/Role/FilePruner.pm) perl(Dist/Zilla/Role/InstallTool.pm) perl(Dist/Zilla/Role/LicenseProvider.pm) perl(Dist/Zilla/Role/MetaProvider.pm) perl(Dist/Zilla/Role/NameProvider.pm) perl(Dist/Zilla/Role/PrereqSource.pm) perl(Dist/Zilla/Role/Releaser.pm) perl(Dist/Zilla/Role/VersionProvider.pm) perl(File/Spec.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/Build/Tiny.pm) perl(Module/Metadata.pm) perl(Moose.pm)
BuildRequires: perl(Moose/Util.pm) perl(Path/Tiny.pm) perl(Software/License/Artistic_2_0.pm) perl(Storable.pm) perl(Term/ANSIColor.pm) perl(Test/DZil.pm) perl(Test/Deep.pm) perl(Test/Deep/NoTest.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(if.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.016
Release: alt1
Summary: Compare data and files at different phases of the distribution build process
Group: Development/Perl
License: perl
URL: https://github.com/karenetheridge/Dist-Zilla-Plugin-VerifyPhases

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETHER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin runs in multiple the Dist::Zilla manpage phases to check what actions have
taken place so far.  Its intent is to find any plugins that are performing
actions outside the appropriate phase, so they can be fixed.

Running at the end of the `-FileGatherer' phase, it verifies that the
following distribution properties have not yet been populated/calculated, as
they usually depend on having the full complement of files added to the
distribution, with known encodings:

=over 4

=item *

name

=item *

version

=item *

abstract

=item *

main_module

=item *

license

=item *

authors

=item *

metadata

=back

Running at the end of the `-EncodingProvider' phase, it forces all encodings
to be built (by calling their lazy builders), to use their `SetOnce' property
to ensure that no subsequent phase attempts to alter a file encoding.

Running at the end of the `-FilePruner' phase, it verifies that no additional
files have been added to the distribution, nor renamed, since the
`-FileGatherer' phase.

Running at the end of the `-FileMunger' phase, it verifies that no additional
files have been added to nor removed from the distribution, nor renamed, since
the `-FilePruner' phase. Additionally, it verifies that the prerequisite list
has not yet been read from, when possible.

Running at the end of the `-AfterBuild' phase, the full state of all files
are checked: files may not be added, removed, renamed nor had their content
change.

=for stopwords FromCode

Currently, FromCode files are not checked for
content, as interesting side effects can occur if their content subs are run
before all content is available (for example, other lazy builders can run too
early, resulting in incomplete or missing data).

=for Pod::Coverage BUILD before_build gather_files set_file_encodings prune_files munge_files after_build


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
