%define module_name Dist-Zilla-Plugin-lib
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dist/Zilla/Role/Plugin.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Moose.pm) perl(MooseX/Types/Moose.pm) perl(Path/Tiny.pm) perl(Test/DZil.pm) perl(Test/More.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001002
Release: alt1
Summary: A simpler bootstrap for a more civilised world
Group: Development/Perl
License: perl
URL: https://github.com/kentnl/Dist-Zilla-Plugin-lib

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KE/KENTNL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Dist::Zilla::Plugin::lib serves as a relatively straight-forward and
uncomplicated way to wire certain local paths in your distributions
source tree into Perl's `@INC' library load path.

Its primary audiences are twofold.

=over 4

=item Self-Building Dist::Zilla Plugins

Many recent Dist::Zilla plugin workflows champion a
state of `lib/' which are usable "as is" without needing to cycle
through a `dzil build' phase first, and this plugin offers a simple
way to stash `lib/' in `@INC' without needing to pass `-Ilib' every
time you run `dzil'.

Workflows that require a build cycle to self-build should use
`[Bootstrap::lib]' instead.

=item Bundled Dist::Zilla Plugins

Many heavy `CPAN' distributions have bundled within them custom `Dist::Zilla'
plugins stashed in `inc/'

Traditionally, these are loaded via `[=inc::Foo::Package]' exploiting
the long held assumption that `"."' ( `$CWD' ) is contained in `@INC'

However, that is becoming a less safe assumption, and this
plugin aims to make such equivalent behaviour practical without needing to
rely on that assumption.

=back

=for Pod::Coverage mvp_multivalue_args
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README examples
%perl_vendor_privlib/D*

%changelog
