%define module_name Dist-Zilla-PluginBundle-Author-GTERMARS
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dist/Zilla.pm) perl(Dist/Zilla/Plugin/Bootstrap/lib.pm) perl(Dist/Zilla/Plugin/BumpVersionAfterRelease.pm) perl(Dist/Zilla/Plugin/CheckIssues.pm) perl(Dist/Zilla/Plugin/CopyFilesFromBuild.pm) perl(Dist/Zilla/Plugin/EnsureChangesHasContent.pm) perl(Dist/Zilla/Plugin/EnsureMinimumPerl.pm) perl(Dist/Zilla/Plugin/Git.pm) perl(Dist/Zilla/Plugin/GitHub.pm) perl(Dist/Zilla/Plugin/GitHub/RequireGreenBuild.pm) perl(Dist/Zilla/Plugin/Prereqs/AuthorDeps.pm) perl(Dist/Zilla/Plugin/Prereqs/FromCPANfile.pm) perl(Dist/Zilla/Plugin/PromptIfStale.pm) perl(Dist/Zilla/Plugin/ReadmeAnyFromPod.pm) perl(Dist/Zilla/Plugin/RunExtraTests.pm) perl(Dist/Zilla/Plugin/StaticInstall.pm) perl(Dist/Zilla/Plugin/Test/CleanNamespaces.pm) perl(Dist/Zilla/Plugin/Test/Compile.pm) perl(Dist/Zilla/Plugin/Test/DiagINC.pm) perl(Dist/Zilla/Plugin/Test/EOF.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/EOL.pm) perl(Dist/Zilla/Plugin/Test/Kwalitee.pm) perl(Dist/Zilla/Plugin/Test/MinimumVersion.pm) perl(Dist/Zilla/Plugin/Test/NoBreakpoints.pm) perl(Dist/Zilla/Plugin/Test/NoTabs.pm) perl(Dist/Zilla/Plugin/Test/PodSpelling.pm) perl(Dist/Zilla/Plugin/Test/ReportPrereqs.pm) perl(Dist/Zilla/Plugin/Test/Synopsis.pm) perl(Dist/Zilla/Plugin/Test/UnusedVars.pm) perl(Dist/Zilla/PluginBundle/Git/CheckFor.pm) perl(Dist/Zilla/Role/PluginBundle/Config/Slicer.pm) perl(Dist/Zilla/Role/PluginBundle/PluginRemover.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Moose.pm) perl(Test/DiagINC.pm) perl(Test/More.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Plugin Bundle for distributions built by GTERMARS
Group: Development/Perl
License: artistic_2
URL: https://metacpan.org/release/Dist-Zilla-PluginBundle-Author-GTERMARS/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GT/GTERMARS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is the `Dist::Zilla' plugin bundle that GTERMARS uses to build his
distributions.

It is *roughly* equivalent to the following:

  ; ==============================================================================
  ; Ensure we're using the correct Author Bundle
  [PromptIfStale / Stale author bundle]
  phase = build
  module = Dist::Zilla::PluginBundle::Author::GTERMARS

  ; ==============================================================================
  ; Gather up all the files we need in our distribution
  [GatherDir]
  exclude_filename = dist.ini
  exclude_filename = cpanfile
  [ExecDir]
  [ShareDir]
  [PruneCruft]

  ; ==============================================================================
  ; Auto-generate files as needed...
  ; ... Makefile.PL
  [MakeMaker]
  ; ... MANIFEST
  [Manifest]
  ; ... LICENSE
  [License]
  ; ... README file(s)
  [ReadmeAnyFromPod / ReadmeGfmInRoot]
  [ReadmeAnyFromPod / ReadmeInDist]
  ; ... Dependencies
  [Prereqs::FromCPANfile]
  [Prereqs::AuthorDeps]
  ; ... META
  [MetaYAML]
  [MetaJSON]
  [MetaNoIndex]
  directory = examples
  directory = inc
  directory = local
  directory = share
  directory = t
  directory = xt
  ; ... Tests
  [MetaTests]
  [Test::ReportPrereqs]
  verify_prereqs = 1
  [Test::NoTabs]
  [Test::EOL]
  [Test::EOF]
  [Test::MinimumVersion]
  [Test::Synopsis]
  [PodSyntaxTests]
  [PodCoverageTests]
  [Test::PodSpelling]
  [Test::NoBreakpoints]
  [Test::CleanNamespaces]
  [Test::DiagINC]
  [Test::UnusedVars]
  [Test::Kwalitee]
  [Test::Compile]
  xt_mode = 1
  fake_home = 1
  filename = xt/author/compile.t
  fail_on_warning = author
  bail_out_on_fail = 1

  ; ==============================================================================
  ; Additional Metadata
  [GitHub::Meta]
  [StaticInstall]
  mode = auto

  ; ==============================================================================
  ; Run "xt/" tests, but don't include them in the release.
  [RunExtraTests]

  ; =======================================================================...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/D*

%changelog
