%define module_name Dist-Zilla-PluginBundle-Starter
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dist/Zilla.pm) perl(Dist/Zilla/Plugin/BumpVersionAfterRelease.pm) perl(Dist/Zilla/Plugin/ConfirmRelease.pm) perl(Dist/Zilla/Plugin/CopyFilesFromRelease.pm) perl(Dist/Zilla/Plugin/DistINI.pm) perl(Dist/Zilla/Plugin/ExecDir.pm) perl(Dist/Zilla/Plugin/FakeRelease.pm) perl(Dist/Zilla/Plugin/GatherDir.pm) perl(Dist/Zilla/Plugin/License.pm) perl(Dist/Zilla/Plugin/MakeMaker.pm) perl(Dist/Zilla/Plugin/MakeMaker/Awesome.pm) perl(Dist/Zilla/Plugin/Manifest.pm) perl(Dist/Zilla/Plugin/ManifestSkip.pm) perl(Dist/Zilla/Plugin/MetaConfig.pm) perl(Dist/Zilla/Plugin/MetaJSON.pm) perl(Dist/Zilla/Plugin/MetaNoIndex.pm) perl(Dist/Zilla/Plugin/MetaProvides/Package.pm) perl(Dist/Zilla/Plugin/MetaYAML.pm) perl(Dist/Zilla/Plugin/ModuleBuildTiny.pm) perl(Dist/Zilla/Plugin/ModuleBuildTiny/Fallback.pm) perl(Dist/Zilla/Plugin/NextRelease.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Pod2Readme.pm) perl(Dist/Zilla/Plugin/PodSyntaxTests.pm) perl(Dist/Zilla/Plugin/PruneCruft.pm) perl(Dist/Zilla/Plugin/PruneFiles.pm) perl(Dist/Zilla/Plugin/ReadmeAnyFromPod.pm) perl(Dist/Zilla/Plugin/Regenerate/AfterReleasers.pm) perl(Dist/Zilla/Plugin/RewriteVersion.pm) perl(Dist/Zilla/Plugin/RunExtraTests.pm) perl(Dist/Zilla/Plugin/ShareDir.pm) perl(Dist/Zilla/Plugin/TemplateModule.pm) perl(Dist/Zilla/Plugin/Test/Compile.pm) perl(Dist/Zilla/Plugin/Test/ReportPrereqs.pm) perl(Dist/Zilla/Plugin/TestRelease.pm) perl(Dist/Zilla/Plugin/UploadToCPAN.pm) perl(Dist/Zilla/Role/MintingProfile/ShareDir.pm) perl(Dist/Zilla/Role/PluginBundle/Config/Slicer.pm) perl(Dist/Zilla/Role/PluginBundle/Easy.pm) perl(Dist/Zilla/Role/PluginBundle/PluginRemover.pm) perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(Moose.pm) perl(Path/Tiny.pm) perl(Test/DZil.pm) perl(Test/File/ShareDir/Module.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 5.0.2
Release: alt1
Summary: A minimal Dist::Zilla plugin bundle
Group: Development/Perl
License: artistic_2
URL: https://metacpan.org/pod/Dist::Zilla::Starter

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
The `[@Starter]' plugin bundle for the Dist::Zilla manpage is designed to do the
minimal amount of work to release a complete distribution reliably. It is
similar in purpose to [@Basic], but with
additional features to stay up to date and allow greater customization. The
selection of included plugins is intended to be unopinionated and unobtrusive,
so that it is usable for any well-formed CPAN distribution. If you're just
getting started with the Dist::Zilla manpage, check out the tutorials at
http://dzil.org.

Migrating from `[@Basic]' is easy for most cases. Most of the bundle is the
same, so just make sure to remove any extra plugins that `[@Starter]' already
includes, and configure the included plugins if needed (see the section on "CONFIGURING").
Migrating a more complex set of plugins, including some that interact with the
additional generated files, may require more careful consideration.

`[@Starter]' composes the PluginRemover
and Config::Slicer roles to
make it easier to customize and extend. Also, it supports bundle revisions
specified as an option, in order to incorporate future changes to distribution
packaging and releasing practices. Existing revisions will not be changed to
preserve backwards compatibility.

The `FAKE_RELEASE' environment variable is supported as in the Dist::Milla manpage and
the Minilla manpage. It replaces the [UploadToCPAN]
plugin with [FakeRelease], to test the
release process (including any version bumping and commits!) without actually
uploading to CPAN.

  $ FAKE_RELEASE=1 dzil release

For one-line initialization of a new `[@Starter]'-based distribution, try
the Dist::Zilla::MintingProfile::Starter manpage.

Another simple way to use the Dist::Zilla manpage is with the Dist::Milla manpage, an opinionated
bundle that requires no configuration and performs all of the tasks in
the section on "EXTENDING" by default.
%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE CONTRIBUTING.md
%perl_vendor_privlib/D*
%perl_vendor_privlib/auto/*

%changelog
