%define module_name Dist-Zilla-PluginBundle-WCS
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dist/Zilla.pm) perl(Dist/Zilla/PluginBundle/Basic.pm) perl(Dist/Zilla/PluginBundle/Filter.pm) perl(Dist/Zilla/PluginBundle/Git.pm) perl(Dist/Zilla/Role/PluginBundle/Config/Slicer.pm) perl(Dist/Zilla/Role/PluginBundle/Easy.pm) perl(Dist/Zilla/Role/PluginBundle/PluginRemover.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Moose.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Elemental/Transformer/List.pm) perl(Pod/Weaver/Section/Contributors.pm) perl(Test/CPAN/Meta.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(blib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: WCS distribution build
Group: Development/Perl
License: perl
URL: https://github.com/wscherz/Dist-Zilla-PluginBundle-WCS

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WC/WCS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is the plugin bundle that WCS uses.  It is equivalent to:

  [Git::NextVersion]
  [License]
  [CopyFilesFromBuild]
  copy = LICENSE

  [GatherDir]
  exclude_filename = LICENSE

  [PkgVersion]
  die_on_existing_version = 1
  die_on_line_insertion = 1

  [NextRelease]
  timezone = America/Chicago
  format = %%-9v %%{yyyy-MM-dd}d

  [@Git]
  remotes_must_exist = 0
  push_to = 'origin :'
  push_to = 'backup :'

  [@Filter]
  -bundle = @Basic
  -remove = License
  -remove = GatherDir

  [InstallGuide]
  [Git::Contributors]
  [GithubMeta]
  [MetaConfig]
  [MetaYAML]
  [MetaJSON]
  [PodWeaver]
  [ReadmeAnyFromPod
  type = pod
  filename = README.pod
  location = root

  [AutoPrereqs]
  [MetaTests]
  [Test::ChangesHasContent]
  [Test::NoTabs]
  [Test::EOL]
  trailing_whitespace = 1
  all_resons = 1

  [Test::Compile]
  [PodSyntaxTests]
  [PodCoverageTests]
  [Test::Pod::No404s]
  [Test::ReportPrereqs]
  [Test::Perl::Critic]
  [Test::Kwalitee]
  [Git::CommitBuild]
  branch =
  release_branch = release
  release_message = Build release of %%v (on %%b)

  [TestRelease]
  [ConfirmRelease]

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/D*

%changelog
