# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Shell
%define upstream_version 0.005

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    An interactive shell for Dist::Zilla
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Term/ReadLine.pm)
BuildRequires: perl(Text/ParseWords.pm)
BuildArch:  noarch
Source44: import.info

%description
This module adds a new command to the Dist::Zilla manpage: 'shell'. Run it
and an interactive shell is opened. You can then run any other Dist::Zilla
command that you usually run with "dzil _command_" (even 'shell' itself, to
open a sub-shell, but that is useless). Type 'q|quit|exit|x' to exit the
shell.

Any command unknown to Dist::Zilla is executed in a system shell, so you
can mix DZ commands and system commands (ls, prove, git...).

Running DZ commands from a shell brings the benefit of avoiding the huge
startup cost due to Moose and all Dist::Zilla plugins. So the first run of
a command under the shell may be still slow, but any successive run will be
much faster.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.yml README
%perl_vendor_privlib/*

%changelog
