# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(File/Path.pm) perl(File/Spec/Functions.pm) perl(JSON.pm) perl(Module/Build.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Test/Cmd.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Docker-Construct
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: Construct the filesystem of an exported docker image.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CA/CAMTAUXE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is the backend module for the the docker-construct manpage command-line tool. For
basic usage, refer to its documentation instead.

    use Docker::Construct qw(construct);

    # Minimal usage
    construct('path/to/image.tar', 'path/to/output/dir');

    # With options
    construct(
        image           => 'path/to/image.tar',
        dir             => 'path/to/output.dir',
        quiet           => 1,
        include_config  => 1
    )

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/D*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
