%define module_name Document-eSign-Docusign
# BEGIN SourceDeps(oneline):
BuildRequires: perl(HTTP/Headers.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(URI.pm) perl(XML/LibXML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Provides an interface for Perl to the Docusign REST API.
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GH/GHENRY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module supplies Perl centric methods for accessing the Docusign API.

Example:

    use Document::eSign::Docusign;

    my $ds = Document::eSign::Docusign->new(
        baseUrl => 'https://demo.docusign.com/',
        username => 'username@domain.com',
        password => 'yourloginpassword',
        integratorkey => 'yourintegratorkeyfromdocusign'
    );
    
    # The API has already called the "Login" portion of the API, you're ready to go:
    
    my $response = $ds->requestSignatureFromTemplate(
        accountId => $ds->accountId, # Note that this is actually redundant.
        emailSubject => 'You have a document to sign from ACME.com.',
        emailBlurb => 'Here is the XYZ document for you to sign.',
        customFields => {
            textCustomFields => [
                name => 'FIELDNAME',
                value => 'value to place in field',
                show => 'true',
                required => 'true',
            ]
        },
        templateId => 'templateId',
        templateRoles [
            {
                roleName     => 'Signer1', # Description of the signer's role
                name => 'Jane Smith',
                email => 'jsmith@somedomain.com'
            }, # Note that this is a list, so adding more roles creates more signatures.
        ],
        status => 'created', # One of sent or created.
        eventNotification => {}, # Large object, see API docs for details.
        
        
    );
    
    if ( defined $response->{error} ) {
        die "Uh oh, we had an error: " . $response->{error};
    }
    
    ...


%prep
%setup -q -n %{module_name}-%{version}
sed -i -e '/^use .*::/ano strict "subs";' Makefile.PL

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ignore.txt README LICENSE Changes
%perl_vendor_privlib/D*

%changelog
