# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(LWP/UserAgent.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Domain-PublicSuffix
%define upstream_version 0.20

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Default PublicSuffix data file
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Domain/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Class/Accessor/Fast.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Net/IDN/Encode.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This module utilizes the "effective_tld_names.dat" provided by Mozilla as a
way to effectively reduce a fully qualified domain name down to the
absolute root. The Mozilla PublicSuffix file is an open source, fully
documented format that shows absolute root TLDs, primarily for Mozilla's
browser products to be able to determine how far a cookie's security
boundaries go.

This module will attempt to search etc directories in
/usr/share/publicsuffix, /usr, /usr/local, and /opt/local for the
effective_tld_names.dat file. If a file is not found, a default file is
loaded from Domain::PublicSuffix::Default, which is current at the time of
the module's release. You can override the data file path by giving the
new() method a 'data_file' argument.

When creating a new PublicSuffix object, the module will load the data file
as specified, and use the internal structure to parse each domain sent to
the get_root_domain method. To re-parse the file, you must destroy and
create a new object, or execute the _parse_data_file method directly,
though that is not recommended.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.yml  README
%perl_vendor_privlib/*
/usr/bin/get_root_domain
%{_mandir}/man1/get_root_domain.1*

%changelog
