# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Dot
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.1
Release: alt1
Summary: The beginning of a Perl universe
Group: Development/Perl
License: gpl
URL: https://github.com/057a3dd61f99517a3afea0051a49cb27994f94d/Dot

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RS/RSLOVERS/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
`Dot' is an object system, where an object is a hash, a method is a closure,
and a class is a
subroutine. An object always starts as nothing, i.e. `{}', and it could
then be modified by one or more classes at any time by adding/removing/modifying
methods to/from/inside it, with their lexical
environment behind the scene, when they're called (`$obj->{method}(@arg)')
they automatically
know to which object they're bind, on which data they should operate,
so `this' or `self' is not needed, and anything that's not intended to
be public could reside in its own lexical scope, in other words each
method minds its own business at its own place, and yet methods of the same class could also
cooperate by closing over the same data, and all the methods of an object
could cooperate by closing over the object itself. It's a perfect
demonstration of encapsulation, since no coordination is needed between
each method on where to store its own data, in comparison to storing
everything inside the object itself, whenever you choose a place to store
something you have to make sure it's not used by any other method, one way
or the other, otherwise you could end up overwriting somebody else's data.

_sub class {
__my $obj = shift;
__# instance properties shared by all the methods of this class.
__my %%limited;
__$obj->{method} = do {
___# instance properties that's only related to this method.
___my %%secret;
___sub {
____# do something with %%secret, %%limited.
___};
__};
__$obj;
_}
_my $obj = class({});
_$obj->{method}(...);

Classes act like hash modifiers, although you could write a class so that it
always returns a brand new object, it's best to write it as a modifier since
then not only you can create a new object from it you could apply it
to an existing object as well, like `my $obj = class3(class2(class1({})))'.
And that's just how multiple inheritance looks like (more on that later).
One situation that you should always keep in mind is when a method
closes over this object itself, like:

_sub class {
__my $obj = shift;
__...

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING Changes README
%perl_vendor_privlib/D*

%changelog
